/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.uddi;

import filenet.vw.base.VWUDDIRegistry;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventObject;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.table.TableCellEditor;

public class VWUDDIRegistryNameCellEditor
implements TableCellEditor,
FocusListener,
KeyListener,
MouseListener {
    public static final String ACMD_CHANGE_UDDI_REGISTRY = "VWUDDIRegistryNameCellEditorChangeUDDIRegistry";
    protected EventListenerList m_listenerList = null;
    protected transient ChangeEvent m_changeEvent = null;
    protected VWUDDIRegistry[] m_uddiRegistries = null;
    protected JComboBox m_combo = null;
    protected BasicComboBoxEditor m_editor = null;
    protected JTable m_table = null;
    protected int m_clickCountToStart = 0;
    protected String m_currentValue = null;

    public VWUDDIRegistryNameCellEditor(VWUDDIRegistry[] uddiRegistries) {
        this.m_uddiRegistries = uddiRegistries;
        this.m_listenerList = new EventListenerList();
        this.m_combo = new JComboBox();
        this.m_combo.setRenderer(new VWLabelListCellRenderer());
        this.m_combo.setEditable(true);
        this.m_editor = new BasicComboBoxEditor();
        this.m_editor.getEditorComponent().addKeyListener(this);
        this.m_editor.getEditorComponent().addFocusListener(this);
        this.m_combo.setEditor(this.m_editor);
        this.setClickCountToStart(1);
    }

    public void setClickCountToStart(int count) {
        this.m_clickCountToStart = count;
    }

    public int getClickCountToStart() {
        return this.m_clickCountToStart;
    }

    public void setValue(Object newValue) {
        if (newValue != null && newValue instanceof String) {
            this.m_currentValue = (String)newValue;
            this.m_editor.setItem(newValue);
        }
    }

    public void updateCurrentValue() {
        Object selItem = this.m_editor.getItem();
        if (selItem != null && selItem instanceof String) {
            this.m_currentValue = (String)selItem;
        }
    }

    public Component getComponent() {
        return this.m_combo;
    }

    public boolean startCellEditing(EventObject anEvent) {
        return true;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (table != null) {
            this.m_table = table;
            this.m_table.addMouseListener(this);
        }
        if (this.m_uddiRegistries != null && this.m_combo != null) {
            this.m_combo.removeAllItems();
            DefaultComboBoxModel<String> cbModel = new DefaultComboBoxModel<String>();
            for (int i = 0; i < this.m_uddiRegistries.length; ++i) {
                if (this.m_uddiRegistries[i].getPublishURL() == null) continue;
                cbModel.addElement(this.m_uddiRegistries[i].getName());
            }
            this.m_combo.setModel(cbModel);
            this.m_combo.setSelectedIndex(-1);
        }
        if (value != null && value instanceof String) {
            this.setValue(value);
        }
        return this.m_combo;
    }

    public void addActionListener(ActionListener l) {
        if (this.m_combo != null) {
            this.m_combo.addActionListener(l);
            this.m_combo.setActionCommand(ACMD_CHANGE_UDDI_REGISTRY);
        }
    }

    public void addCellEditorListener(CellEditorListener l) {
        this.m_listenerList.add(CellEditorListener.class, l);
    }

    public void cancelCellEditing() {
        if (this.m_table != null) {
            this.m_table.removeMouseListener(this);
            this.m_table = null;
        }
        this.fireEditingCanceled();
    }

    public Object getCellEditorValue() {
        return this.m_currentValue;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return !(anEvent instanceof MouseEvent) || ((MouseEvent)anEvent).getClickCount() >= this.m_clickCountToStart;
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.m_listenerList.remove(CellEditorListener.class, l);
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        boolean retValue = true;
        if (this.isCellEditable(anEvent) && (anEvent == null || ((MouseEvent)anEvent).getClickCount() >= this.m_clickCountToStart)) {
            retValue = this.startCellEditing(anEvent);
        }
        return retValue;
    }

    public boolean stopCellEditing() {
        if (this.m_table != null) {
            this.m_table.removeMouseListener(this);
            this.m_table = null;
        }
        this.updateCurrentValue();
        this.fireEditingStopped();
        return true;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (!e.isTemporary()) {
            this.stopCellEditing();
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\n') {
            this.stopCellEditing();
        }
    }

    public void mouseClicked(MouseEvent evt) {
        if (evt.getSource().equals(this.m_table)) {
            this.stopCellEditing();
        }
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CellEditorListener.class) continue;
            if (this.m_changeEvent == null) {
                this.m_changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i + 1]).editingStopped(this.m_changeEvent);
        }
    }

    protected void fireEditingCanceled() {
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CellEditorListener.class) continue;
            if (this.m_changeEvent == null) {
                this.m_changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i + 1]).editingCanceled(this.m_changeEvent);
        }
    }
}

